/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DnsAp_Public.h 75815 2018-05-15 14:31:08Z trieu                       $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------
     1         30.05.2012   TD
     Created
*******************************************************************************/
#ifndef __DNSAP__PUBLIC_H
#define __DNSAP__PUBLIC_H


/******************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'DnsAp '.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 DNSAP_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(DNSAP_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define DNSAP_QUEUE_NAME        "QUE_DNSAP"

/******************************************************************************/
/* DNS AP Commands */
#define DNS_AP_CMD_RANGE_START                    0x00004100
#define DNS_AP_CMD_SET_CONFIGURATION_REQ          0x00004100
#define DNS_AP_CMD_SET_CONFIGURATION_CNF          0x00004101
#define DNS_AP_CMD_WATCHDOG_TIMEOUT_REQ            0x00004102
#define DNS_AP_CMD_WATCHDOG_TIMEOUT_CNF            0x00004103
#define DNS_AP_CMD_GET_LED_STATE_REQ              0x00004104
#define DNS_AP_CMD_GET_LED_STATE_CNF              0x00004105
#define DNS_AP_CMD_RANGE_END                       0x00004105


#define DNS_AP_WD_OFF                             0x00000000L
#define DNS_AP_WD_MIN_TIMEOUT                     0x00000014L
#define DNS_AP_WD_MAX_TIMEOUT                     0x0000FFFFL

/** @} */

/* DNS AP Commands  */

/******************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__DNSAP_PACKET)
#endif


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__DNSAP_PACKET)
#endif

/******************************************************************************/
/*                     DNS_AP_CMD_GET_LED_STATE_REQ Structure                    */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_APP_GET_LED_STATE_REQ_DATA_Ttag
{
  TLR_UINT32 ulLedType;                      /* MNS = 1. #DNS_FAL_LED_TYPE_MNS*/
} DNS_APP_GET_LED_STATE_REQ_DATA_T;

#define DNS_APP_GET_LED_STATE_REQ_SIZE\
                                      (sizeof(DNS_APP_GET_LED_STATE_REQ_DATA_T))

typedef __PACKED_PRE struct __PACKED_POST DNS_APP_PACKET_GET_LED_STATE_REQ_Ttag
{
  TLR_PACKET_HEADER_T              tHead;
  DNS_APP_GET_LED_STATE_REQ_DATA_T tData;
} DNS_APP_PACKET_GET_LED_STATE_REQ_T;

/******************************************************************************/
/*                       DNS_AP_CMD_GET_LED_STATE_CNF Structure                  */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_APP_GET_LED_STATE_CNF_DATA_Ttag
{
  TLR_UINT32 ulLedType;  /* MNS = 1. #DNS_FAL_LED_TYPE_MNS*                   */
  TLR_UINT32 ulLedMode;  /* STATIC = 1, FLASH = 2, DNS_FAL_LED_MODE_..        */
  TLR_UINT32 ulLedColor; /* RED = 3, GRN = 2, OFF= 1, DNS_FAL_LED_COLOR_ ..   */
} DNS_APP_GET_LED_STATE_CNF_DATA_T;


typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_GET_LED_STATE_CNF_Ttag
{
  TLR_PACKET_HEADER_T              tHead;

  DNS_APP_GET_LED_STATE_CNF_DATA_T tData;

}DNS_APP_PACKET_GET_LED_STATE_CNF_T;

#define DNS_APP_GET_LED_STATE_CNF_SIZE\
                                      (sizeof(DNS_APP_GET_LED_STATE_CNF_DATA_T))



/******************************************************************************/
/*                     CIP Device ID: Use for taglist                         */
/******************************************************************************/
typedef struct //DNS_TAG_CIP_DEVICEID_DATA_Ttag
{
  TLR_UINT16 usVendorID;                                         /* Vendor ID */
  TLR_UINT16 usDeviceType;                                     /* Device Type */
  TLR_UINT16 usProductCode;                                   /* Product Code */
  TLR_UINT8  bMajRev;                                       /* Major Revision */
  TLR_UINT8  bMinRev;                                       /* Minor Revision */
  TLR_UINT8  abProductName[32];                               /* Product Name */
}DNS_APP_DEVICEID_T;

/******************************************************************************/
#endif /* #ifndef __DNSAP__PUBLIC_H */
